*******************************************************************************
*                     68000/68010 Grundprogramm grafgdpc                      *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                         Farbgrafik-Paket fr GDP                            *
*******************************************************************************

                                * ACHTUNG nicht mit Schwarz und XOR fllen
gr3p11:                         * Flche fllen ( Nur bei neuer GDP )
 cmp #511,d2
 bhi carset                     * Auerhalb des Bereichs
 cmp #511,d1
 bhi carset                     * Auerhalb des Bereichs
 movem.l d0-d6/a0,-(a7)
 lea page.w,a0                  * Auslese-Adresse
 lea gdp.w,a6                   * GDP-Basis-Register
 bsr g3moveto                   * Positionieren
 btst.b #1, gdp+1*cpu.w
 bne.s gr3p11aa
 move.b fgcolor(a5), d6
 bra.s gr3p11ab
gr3p11aa:
 move.b bgcolor(a5), d6
gr3p11ab:
 and #$f, d6
 bsr gr3p11h0                   * Punkt aus Bildschirmspeicher holen
 bne.s gr3p11fi                 * Wenn Farben gleich, dann Ende
 move #512,d5                   * Rechte Grenze
 move #-1,-(a7)                 * Endekennung Eckpunkte
 move d1,d3                     * X-Koordiante auch
 bsr.s gr3p11e                  * Linke Grenze holen
 movem.w d1/d2,-(a7)            * Merken (Auch Y-Koordinate)
 move d3,d1                     * X zurck
 bsr gr3p11f                    * Rechte Grenze holen
 move d1,-(a7)                  * Merken
gr3p11a:                        * Schleife
 move (a7)+,d3                  * Rechte Grenze vom Stack holen
 bmi.s gr3p11fi                 * Negativ, dann Stack leer und Ende
 movem.w (a7)+,d1/d2            * Linke Grenze und Y-Koordinate vom Stack holen
 bsr move3to
 bsr gr3p11h0                   * Punkt an aktueller Stelle holen
 bne.s gr3p11a                  * Schon gefllt, dann weiter
 bsr gr1xline                   * Linie ziehen
 move d1,d4                     * d1 merken
 addq.b #1,d2                   * Eine Reihe hoch
 bsr wait3                      * Warten bis GDP fertig
 addq.b #1,gdp+$b*cpu.w         * GDP Y-Register auch erhhen
 beq.s gr3p11c                  * Obere Grenze erreicht
 bsr.s gr3p11e                  * Nach links, bis Farben ungleich
gr3p11b:
 bsr gr3p11g                    * Jetzt linke Grenze holen
 bcs.s gr3p11c                  * Fehler, keine linke Grenze gefunden
 movem.w d1/d2,-(a7)            * Werte merken
 bsr.s gr3p11f                  * Rechte Grenze holen
 move d1,-(a7)                  * Merken
 addq #1,d1                     * X-Koordinate erhhen
 cmp d1,d3                      * Nicht ber rechte Grenze hinaus
 bhi.s gr3p11b
gr3p11c:
 subq.b #2,d2                   * Eine Reihe tiefer (addq #1,d2 ausgleichen)
 cmp.b #255,d2                  * berlauf ?
 beq.s gr3p11a                  * Ja, dann nchste Linie
 subq.b #2,gdp+$b*cpu.w         * Y-Koordinate erniedrigen
 move d4,d1                     * d1 zurck
 bsr.s gr3p11e                  * Und wie oben
gr3p11d:
 bsr.s gr3p11g
 bcs.s gr3p11a
 movem.w d1/d2,-(a7)
 bsr.s gr3p11f
 move d1,-(a7)
 addq #1,d1
 cmp d1,d3
 bhi.s gr3p11d
 bra.s gr3p11a
gr3p11fi:
 movem.l (a7)+,d0-d6/a0         * Register zurck
 bra carres                     * OK, alles klar

gr3p11e:                        * Nach links suchen, bis Schreibfarbe<>Bildfarbe
 bsr.s gr3p11h                  * Punkt holen
 bne.s gr3p11e3                 * Ungleich, dann OK
gr3p11e2:
 subq #1,d1                     * 1 zurck
 bpl.s gr3p11e                  * Positiv, dann wiederholen
 addq #1,d1                     * Sonst auf 0 und Ende
 rts

gr3p11e3:
 cmp #511,d1                    * Ganz rechts ?
 beq.s gr3p11e4                 * Ja, dann Ende
 addq #1,d1                     * Sonst 1 nach rechts
gr3p11e4:
 rts

gr3p11f:                        * Rechte Grenze suchen
 bsr.s gr3p11h                  * Punkt holen
 bne.s gr3p11f3                 * OK, Ende
 addq #1,d1                     * 1 dazu
 cmp d5,d1                      * Rechte Grenze erreicht ?
 bne.s gr3p11f                  * Nein, dann weiter
gr3p11f3:
 subq #1,d1                     * 1 zurck
 rts

gr3p11g:
 move d1,-(a7)
gr3p11g0:
 bsr.s gr3p11h                  * Linke Grenze suchen
 beq.s gr3p11g3                 * OK, gefunden
 addq #1,d1                     * 1 dazu
 cmp d5,d1                      * Rechte Grenze erreicht ?
 bne.s gr3p11g0                 * Nein, dann weitersuchen
 addq.l #2,a7                   * Stack abbauen
 bra carset                     * Fehler, keine linke Grenze gefunden
gr3p11g3:
 move (a7)+,d0                  * Anfangsprfpunkt nach d0
 cmp d3,d1                      * ber rechte Grenze hinaus ?
 bhi carset                     * Ja, Fehler
 cmp d0,d1
 bpl carres
 move d0,d1
 bra carres                     * OK, Linke Grenze korrekt gefunden

gr3p11h:                        * Einen Punkt prfen
 movep.w d1,8*cpu(a6)           * X-Koordinate einstellen ==> Nur fr 68000
gr3p11h0:                       * Extra-Einsprung
 move.b #$f,(a6)                * Befehl fr Speicher auslesen
 move d1,d0                     * X-Koordinate holen
 not d0
 and #1, d0
 asl #2, d0
gr3p11h1:
 btst.b #2,(a6)                 * Warten, bis GDP fertig
 beq.s gr3p11h1
 move.b (a0),d7                 * Wert holen
 lsr d0,d7                      * Bit fr Punkt an die richtige Stelle bringen
 not d7
 and #$f,d7                     * Nur diesen Punkt lassen
 cmp.b d6,d7                    * Vergleich
 rts                            * Ende

gr3p15:                         * Schreibfarbe + Verknpfungsmode
 tst d1                         * schwarz?
 beq.s gr3p15a                  * ja!
 clr.b bgcolor(a5)              * Hintergrund schwarz
 move.b d1, fgcolor(a5)
 move.b #1, gdpcolor(a5)        * Nur 0 oder 1
 move.b gdp+1*cpu.w, d7
 or.b #$03, d7                  * Screibstift und setzen
 bsr wait3
 move.b d7, gdp+1*cpu.w
 bra.s gr3p15b
gr3p15a:
 move.b #1, bgcolor(a5)         * weier Hintergrund
 move.b d1, fgcolor(a5)
 clr.b gdpcolor(a5)
 move.b gdp+1*cpu.w, d7
 bclr.b #1, d7                  * Lschstift
 bset.b #0, d7                  * Setzen
 bsr wait3
 move.b d7, gdp+1*cpu.w
gr3p15b:
 move.b fgcolor(a5), colport.w
 move.b bgcolor(a5), colport1.w
 move.b d2, d7
 and.b #1, d7
 move.b d7, gdpxor(a5)          * Nur an oder aus
 bra gr1page

gr3p16:                         * Farbe und Verknpfungsmode abfragen
                                * Ergebnis d1 = Farbe / d2 = Verknpfungsmode
 moveq #0, d2                   * Langwort gltig
 move.b gdpxor(a5), d2          * d2.b ist Verknpfungsmode (0/1)
 moveq #0, d1                   * Langwort gltig
 move.b fgcolor(a5), d1         * In d1.b ist die Farbe
 rts

gr3p19:                         * Einen Punkt abfragen
 cmp #511,d2
 bhi carset                     * Auerhalb des Screens
 cmp #511,d1
 bhi carset                     * Auerhalb des Screens
 moveq #0,d3                    * Bit innerhalb Langwort gltig
 move d2,d7
 bsr g3moveto                   * d3 ist Ergebnis Punkt
 move.b #$f,gdp.w               * Befehl fr Speicher auslesen
 move d7,d2                     * d2 zurck
 move d1,d7                     * X-Koordinate nach d7
 not d7
 and #1, d7
 asl #2, d7
gr3p19a:
 btst.b #2,gdp.w                * WAIT
 beq.s gr3p19a
 move.b page.w,d3               * Ein Byte aus Speicher holen
 lsr.b d7,d3                    * Punkt an die richtige Stelle schieben
 not.b d3                       * Umdrehen, da invers im Speicher
 and.b #$f,d3                   * Bit 0-3 ist Punkt
 bra carres

gr3p20:                         * Hardcopy erstellen
 movem.l d0-d3/a0,-(a7)
 moveq #2,d3                    * WAIT-Bit der GDP-Karte
 moveq #$f,d7                   * Befehl fr Speicher auslesen
 lea gdp.w,a6                   * GDP-Basis-Register
 bsr wait3                      * Warten bis GDP fertig
 move.b #$e,gdp.w               * Y-Pos auf Null
 move.b #1,gdp+$8*cpu.w         * X-High auf 1, da Hlfte gleich getauscht wird
 clr.b gdp+$9*cpu.w             * X-Low auf Null
 move #256-1,d2                 * 256 Zeilen
gr3p20a:
 subq.b #1,gdp+$b*cpu.w         * Y-Koordinate erniedrigen
 moveq #2-1,d1                  * X-Bereich in zwei Teile geteilt
gr3p20b:
 eori.b #1,gdp+$8*cpu.w         * X-Bereich wechseln
 moveq #128-1,d0                * 128 Bytes holen
gr3p20c:
 move.b d7,(a6)                 * Speicher auslesen
gr3p20d:
 btst.b d3,(a6)                 * WAIT
 beq.s gr3p20d
 move.b page.w,(a0)             * Wert holen
 not.b (a0)+                    * Steht invers im Screen der GDP, deshalb NOT
 addq.b #2,gdp+$9*cpu.w         * 2 Punkte weiter
 dbra d0,gr3p20c
 dbra d1,gr3p20b
 dbra d2,gr3p20a
 movem.l (a7)+,d0-d3/a0
 bra carres                     * OK, alles klar


gr3p21:                         * Bild laden
 movem.l d0-d6/a0-a2,-(a7)      * In a0 steht Quelle (Mu gerade Adresse sein)
 moveq #2,d6                    * WAIT-Bit der GDP-Karte
 moveq #$80,d7                  * Befehl fr Punkt setzen
 lea gdp.w,a6                   * GDP-Basis fr WAIT
 lea gdp+9*cpu.w,a1
 lea colport.w, a2
 clr d1                         * X-Koordinate
 bsr wait3
 move.b #1,gdp+8*cpu.w          * X-High auf 1, da Hlfte gleich getauscht wird
 move.b #$e,gdp.w               * Y auf Null
 move #256-1,d2                 * 256 Reihen
gr3p21a:
 btst.b d6,(a6)                 * Warten
 beq.s gr3p21a
 subq.b #1,gdp+$b*cpu.w
 moveq #2-1,d3                  * X geteilt in zwei Hlften wegen 256-Grenze
gr3p21b:
 btst.b d6,(a6)                 * Warten
 beq.s gr3p21b
 eori.b #1,gdp+$8*cpu.w         * Hlfte ndern
 moveq #64-1,d4                 * 64*4*2 = 512
gr3p21c:
 move (a0)+,d0                  * 4 Pixel
 moveq #4-1,d5                  *
gr3p21d:
 rol.l #4, d0                   * Pixel in Bit #16-19
 swap d0                        * jetzt in Bit #0-3
 and.b #$f, d0                  * nur unterstes Nibble
 beq.s gr3p21f                  * Nicht gesetzt
 move.b d1,(a1)                 * Neue X-Koordinate
gr3p21e:
 btst.b d6,(a6)                 * Warten
 beq.s gr3p21e
 move.b d0, (a2)                * Farbe setzen
 move.b d7,(a6)                 * Punkt setzen
gr3p21f:
 swap d0
 addq.b #1,d1
 dbra d5,gr3p21d
 dbra d4,gr3p21c
 dbra d3,gr3p21b
 dbra d2,gr3p21a
 movem.l (a7)+,d0-d6/a0-a2      * Register zurck
 rts

gr3p26:                         * Sprite/Bild schreiben
 movem.l d0-d6/a0-a6, -(a7)
 move.b gdpxor(a5), d0          * XOR-Mode
 move d0, -(a7)                 * auf Stack retten
 lea gdp.w, a6                  * GDP-Basis fr WAIT
 lea gdp+8*cpu.w, a4            * X-Register GDP
 lea gdp+1*cpu.w, a3            * GDP-CTRL1
 lea colport.w, a2              * Farbregister
 move d3, d7                    * Optionen retten
 move.b (a1)+, d6               * Maske
 move.b (a1)+, d5               * Spriteart
 sub (a1)+, d1                  * X-Koordinate - X-Offset
 asr #1, d2                     * auf 0..255
 sub (a1)+, d2                  * Y-Koordinate - Y-Offset
 move.b (a1)+, d3               * X-Scalierung
 move.b (a1)+, d4               * Y-Scalierung
 clr.b colport1.w               * Hintergrundfabe auf 0
 btst.b #0, d5                  * Sprite mit 2 oder 16 Farben?
 bne.s gr3p26a                  * 16!
 move.b 0(a1), (a2)             * Vordergrundfarbe
 move.b 1(a1), colport1.w       * Hintergrundfarbe
gr3p26a:
 addq #8, a1                    * +8 um auf Maske bzw. Bild zu kommen
 btst.b #0, d7                  * Hintergrund speichern?
 bne.s gr3p26b                  * nein!
 bsr gr3sb                      * Speicherroutine
gr3p26b:
 tst.b d6                       * Maske?
 bne gr3p26o                    * nein
 movea.l a1, a0                 * fr Maske
 moveq #8, d0                   * 8 Zeilen
 asl d4, d0                     * *Y-Scalierung
 moveq #2, d7                   * 2 Byte
 asl d3, d7                     * *X-Scalierung
 mulu d7, d0                    * Gre der Maske
 adda d0, a1                    * hier Bildpointer

gr3p26m:                        * mit Maske
 move.b gdpwpage(a5),d6         * Schreibseite
 lsl.b #2,d6
 or.b gdpvpage(a5),d6           * Leseseite
 lsl.b #4,d6
 or.b gdpxor(a5),d6             * XOR-Mode
 moveq #8, d0                   * 8 Zeilen
 lsl d4, d0                     * *Y-Scalierung
 subq #1, d0                    * -1 als Zhler
 move d0, d4                    * nach d4
 btst.b #0, d5                  * 2 oder 16 Farben
 bne gr3p26n                    * 16 Farben dort

gr3p26m1:                       * mit Maske 2 Farben
 tst d2                         * Y >=0 ?
 bpl.s gr3p26m2                 * ja, dann Ausgabe
 moveq #2, d0                   * 2 Byte/Zeile
 lsl d3, d0                     * *X-Scalierung
 adda.l d0, a1                  * Bild auf nchste Zeile
 adda.l d0, a0                  * Maske auch auf
 addq #1, d2                    * nchste Zeile
 dbra d4, gr3p26m1
 bra gr3p26x                    * Ende
gr3p26m2:
 cmp #256, d2                   * oberer Rand berschritten?
 bge gr3p26x                    * Ende
 move.b d2, gdp+$b*cpu.w        * Y-Koordinate setzen
 move d1, -(a7)                 * X-Koordinate retten
 moveq #2, d5                   * 2 Byte
 lsl d3, d5                     * *X-Scalierung
 subq #1, d5                    * -1 als Zhler
gr3p26m3:
 move (a0)+, d0                 * 16 Masken-Pixel
 swap d0
 move (a1)+, d0                 * 16 Bild-Pixel laden
 moveq #16-1, d7                * 16 Bits
gr3p26m4:
 tst d1                         * X-Koordinate
 bpl.s gr3p26m5                 * in Darstellungsbereich
 lsl.l #1, d0
 addq #1, d1                    * sonst nchstes Pixel
 dbra d7, gr3p26m4
 bra.s gr3p26m9                 * hier Ende
gr3p26m5:
 cmp #512, d1                   * rechter Rand berschritten?
 bge.s gr3p26m9                 * dann Ende
gr3p26m6:
 btst.b #2, (a6)                * Warten
 beq.s gr3p26m6
 movep.w d1, 0(a4)              * Neue X-Koordinate -- Nur fr 68000
 lsl #1, d0                     * Pixel-Bit
 bcs.s gr3p26mb                 * gesetzt
 swap d0
 lsl #1, d0                     * Masken-Bit
 bcc.s gr3p26ma                 * wenn 0, dann Pixel belassen
 bra.s gr3p26m7                 * sonst Hintergrundfarbe
gr3p26mb:
 swap d0
 lsl #1, d0                     * Masken-Bit
 bcs.s gr3p26mc                 * Vordergrundfarbe setzen
 btst.b #0, d6                  * XOR-Mode
 bne.s gr3p26md                 * ist gesetzt, dann Pixel ausgeben
 bset.b #0, d6                  * XOR setzen
 move.b d6, page.w              * und ausgeben
 bra.s gr3p26md
gr3p26mc:
 btst.b #0, d6                  * XOR-Mode
 beq.s gr3p26md                 * ist gelscht, dann weiter
 bclr.b #0, d6                  * XOR-Mode lschen
 move.b d6, page.w              * und ausgeben
gr3p26md:
 bset.b #1, (a3)                * Schreibstift
 bra.s gr3p26m8
gr3p26m7:
 bclr.b #1, (a3)                * Lschstift
gr3p26m8:
 move.b #$80, (a6)              * Punkt setzen
gr3p26ma:
 swap d0                        *
 addq #1, d1
 dbra d7, gr3p26m5              * nchster Punkt
gr3p26m9:
 dbra d5, gr3p26m3              * nchsten 2 Byte
 addq #1, d2                    * nchste Zeile
 move (a7)+, d1                 * X-Koordinate zurck
 dbra d4, gr3p26m2
 bra gr3p26x                    * hier Ende

gr3p26n:                        * mit Maske 16 Farben
gr3p26n1:
 tst d2                         * Y >=0 ?
 bpl.s gr3p26n2                 * ja, dann Ausgabe
 moveq #8, d0                   * 8 Byte/Zeile
 lsl d3, d0                     * *X-Scalierung
 adda.l d0, a1                  * Bild auf nchste Zeile
 moveq #2, d0                   * 2 Byte/Zeile
 lsl d3, d0                     * *X-Scalierung
 adda.l d0, a0                  * Maske auf nchste Zeile
 addq #1, d2                    * Y auch auf nchste Zeile
 dbra d4, gr3p26n1
 bra gr3p26x                    * Ende
gr3p26n2:
 cmp #256, d2                   * oberer Rand berschritten?
 bge gr3p26x                    * Ende
 move.b d2, gdp+$b*cpu.w        * Y-Koordinate setzen
 move d1, -(a7)                 * X-Koordinate retten
 moveq #2, d5                   * 8 Byte
 lsl d3, d5                     * *X-Scalierung
 subq #1, d5                    * -1 als Zhler
 swap d2                        *
gr3p26n3:
 move.b (a0)+, d2               * 8 Masken-Pixel
 move.l (a1)+, d0               * 8 Bild-Pixel laden
 moveq #8-1, d7                 * 8 Nibble
gr3p26n4:
 tst d1                         * X-Koordinate
 bpl.s gr3p26n5                 * in Darstellungsbereich
 lsl.b #1, d2                   * Maske
 lsl.l #4, d0                   * Pixel
 addq #1, d1                    * sonst nchstes Pixel
 dbra d7, gr3p26n4
 bra.s gr3p26n9                 * hier Ende
gr3p26n5:
 cmp #512, d1                   * rechter Rand berschritten?
 bge.s gr3p26n9                 * dann Ende
gr3p26n6:
 btst.b #2, (a6)                * Warten
 beq.s gr3p26n6
 movep.w d1, 0(a4)              * Neue X-Koordinate -- Nur fr 68000
 swap d1
 rol.l #4, d0                   * Pixel-Bit
 move.b d0, d1
 and.b #$0f, d1
 bne.s gr3p26nb                 * gesetzt
 lsl.b #1, d2                   * Masken-Bit
 bcc.s gr3p26na                 * wenn 0, dann Pixel belassen
 bra.s gr3p26n7                 * sonst Hintergrundfarbe
gr3p26nb:
 lsl.b #1, d2                   * Masken-Bit
 bcs.s gr3p26nc                 * Vordergrundfarbe setzen
 btst.b #0, d6                  * XOR-Mode
 bne.s gr3p26nd                 * ist gesetzt, dann Pixel ausgeben
 bset.b #0, d6                  * XOR setzen
 move.b d6, page.w              * und ausgeben
 bra.s gr3p26nd
gr3p26nc:
 btst.b #0, d6                  * XOR-Mode
 beq.s gr3p26nd                 * ist gelscht, dann weiter
 bclr.b #0, d6                  * XOR-Mode lschen
 move.b d6, page.w              * und ausgeben
gr3p26nd:
 move.b d1, (a2)                * Farbe
 bset.b #1, (a3)                * Schreibstift
 bra.s gr3p26n8
gr3p26n7:
 bclr.b #1, (a3)                * Lschstift
gr3p26n8:
 move.b #$80, (a6)              * Punkt setzen
gr3p26na:
 swap d1                        *
 addq #1, d1
 dbra d7, gr3p26n5              * nchster Punkt
gr3p26n9:
 dbra d5, gr3p26n3              * nchsten 8 Pixel
 swap d2
 addq #1, d2                    * nchste Zeile
 move (a7)+, d1                 * X-Koordinate zurck
 dbra d4, gr3p26n2
 bra gr3p26x                    * hier Ende

gr3p26o:                        * ohne Maske
 clr.b gdpxor(a5)               * kein XOR
 bsr gr1page                    * Seite und XOR-Modus setzen
 moveq #8, d0                   * 8 Zeilen
 lsl d4, d0                     * *Y-Scalierung
 subq #1, d0                    * -1 als Zhler
 move d0, d4                    * nach d4
 btst.b #0, d5                  * 2 oder 16 Farben
 bne.s gr3p26p                  * 16 Farben dort

gr3p26o1:                       * ohne Maske 2 Farben
 tst d2                         * Y >=0 ?
 bpl.s gr3p26o2                 * ja, dann Ausgabe
 moveq #2, d0                   * 2 Byte/Zeile
 lsl d3, d0                     * *X-Scalierung
 adda.l d0, a1
 addq #1, d2                    * nchste Zeile
 dbra d4, gr3p26o1
 bra gr3p26x                    * Ende
gr3p26o2:
 cmp #256, d2                   * rechter Rand berschritten?
 bge gr3p26x                    * Ende
 move.b d2, gdp+$b*cpu.w        * Y-Koordinate setzen
 move d1, -(a7)                 * X-Koordinate retten
 moveq #2, d5                   * 2 Byte
 lsl d3, d5                     * *X-Scalierung
 subq #1, d5                    * -1 als Zhler
gr3p26o3:
 move (a1)+, d0                 * 16 Pixel laden
 moveq #16-1, d7                * 16 Bits
gr3p26o4:
 tst d1                         * X-Koordinate
 bpl.s gr3p26o5                 * in Darstellungsbereich
 lsl #1, d0
 addq #1, d1                    * sonst nchstes Pixel
 dbra d7, gr3p26o4
 bra.s gr3p26o9                 * hier Ende
gr3p26o5:
 cmp #512, d1                   * rechter Rand berschritten?
 bge.s gr3p26o9                 * dann Ende
gr3p26o6:
 btst.b #2, (a6)                * Warten
 beq.s gr3p26o6
 movep.w d1, 0(a4)              * Neue X-Koordinate -- Nur fr 68000
 lsl #1, d0                     * ein Pixel in Carry
 bcc.s gr3p26o7                 * Schwarz
 bset.b #1, (a3)                * Schreibstift
 bra.s gr3p26o8
gr3p26o7:
 bclr.b #1, (a3)                * Lschstift
gr3p26o8:
 move.b #$80, (a6)              * Punkt setzen
 addq #1, d1
 dbra d7, gr3p26o5              * nchster Punkt
gr3p26o9:
 dbra d5, gr3p26o3              * nchsten 2 Byte
 addq #1, d2                    * nchste Zeile
 move (a7)+, d1                 * X-Koordinate zurck
 dbra d4, gr3p26o2
 bra.s gr3p26x                  * hier Ende

gr3p26p:                        * ohne Maske 16 Farben
gr3p26p1:
 tst d2                         * Y >=0 ?
 bpl.s gr3p26p2                 * ja, dann Ausgabe
 moveq #8, d0                   * 8 Byte/Zeile
 lsl d3, d0                     * *X-Scalierung
 adda.l d0, a1
 addq #1, d2                    * nchste Zeile
 dbra d4, gr3p26p1
 bra.s gr3p26x                  * Ende
gr3p26p2:
 cmp #256, d2                   * oberer Rand berschritten?
 bge.s gr3p26x                  * Ende
 move.b d2, gdp+$b*cpu.w        * Y-Koordinate setzen
 move d1, -(a7)                 * X-Koordinate retten
 moveq #8, d5                   * 8 Byte
 lsl d3, d5                     * *X-Scalierung
 subq #1, d5                    * -1 als Zhler
gr3p26p3:
 move.b (a1)+, d0               * 2 Pixel laden
 moveq #2-1, d7                 * a 4 Bits
gr3p26p4:
 tst d1                         * X-Koordinate
 bpl.s gr3p26p5                 * in Darstellungsbereich
 rol.b #4, d0
 addq #1, d1                    * sonst nchstes Pixel
 dbra d7, gr3p26p4
 bra.s gr3p26p9                 * hier Ende
gr3p26p5:
 cmp #512, d1                   * rechter Rand berschritten?
 bge.s gr3p26p9                 * dann Ende
gr3p26p6:
 btst.b #2, (a6)                * Warten
 beq.s gr3p26p6
 movep.w d1, 0(a4)              * Neue X-Koordinate -- Nur fr 68000
 rol.b #4, d0                   * Pixel ind Bit #3-0
 move.b d0, d6                  * nach d6
 and.b #$0f, d6                 * nur akt. Pixel lassen
 beq.s gr3p26p7                 * Schwarz
 move.b d6, (a2)                * Farbe in colport
 bset.b #1, (a3)                * Schreibstift
 bra.s gr3p26p8
gr3p26p7:
 bclr.b #1, (a3)                * Lschstift
gr3p26p8:
 move.b #$80, (a6)              * Punkt setzen
 addq #1, d1
 dbra d7, gr3p26p5              * nchster Punkt
gr3p26p9:
 dbra d5, gr3p26p3              * nchstes Byte
 addq #1, d2                    * nchste Zeile
 move (a7)+, d1                 * X-Koordinate zurck
 dbra d4, gr3p26p2
gr3p26x:
 move (a7)+, d0
 move.b d0, gdpxor(a5)
 bsr gr1page                    * Seite und XOR-Modus setzen
 movem.l (a7)+, d0-d6/a0-a6
 bra carres                     * OK, alles klar

gr3sb:                          * Hintergrund speichern
 movem.l d0-d6/a0/a3, -(a7)
 lea page.w, a3                 * Seiten Register
 move.b #2, (a0)+               * Spriteart = GDP-COL
 move.b gdpwpage(a5), (a0)+     * Schreibseite
 move d1, (a0)+                 * X-Koordinate
 move d2, (a0)+                 * Y-Koordinate
 move.b d3, (a0)+               * X-Scalierung
 move.b d4, (a0)+               * Y-Scalierung
 addq #8, a0                    * Offset fr Bilddaten
 moveq #8, d5                   * 8 Zeilen
 lsl d4, d5                     * * Y-Scalierung
 subq #1, d5                    * -1 als Zhler
gr3sba:
 tst d2                         * Y >=0 ?
 bpl.s gr3sbb                   * ja, dann Ausgabe
 moveq #10, d0                  * 10 Byte/Zeile
 lsl d3, d0                     * *X-Scalierung
 adda.l d0, a0
 addq #1, d2                    * nchste Zeile
 dbra d5, gr3sba
 bra.s gr3sbx                   * Ende
gr3sbb:
 cmp #256, d2                   * oberer Rand berschritten?
 bge gr3sbx                     * dann Ende
 move.b d2, gdp+$b*cpu.w        * Y-Koordinate setzen
 and #$fffe, d1                 * X auf gerade Adresse bringen
 move d1, -(a7)                 * X-Koordinate sichern
 moveq #1, d6
 asl d3, d6                     * 1*X-Scalierung
 subq #1, d6                    * -1 als Zhler
gr3sbc:
 moveq #9-1, d4                 * max. 2*9 Punkte
gr3sbd:
 movep.w d1, 0(a4)              * X-Koordinate setzen --- Nur fr 68000
 move.b #$f, (a6)               * Befehl fr Speicher auslesen
gr3sbe:
 btst.b #2, (a6)                * WAIT
 beq.s gr3sbe
 move.b (a3), d0                * 2 Pixel holen
 not.b d0                       * inventiert im Grafikspeicher
 move.b d0, (a0)+               * und speichern
 addq #2, d1                    * nchsten Pixel
 dbra d4, gr3sbd
 addq #1, a0                    * auf 10 Byte
 dbra d6, gr3sbc                * bei Scalierung
 move (a7)+, d1                 * X-Koordinate zurck
 addq #1, d2                    * nchste Zeile
 dbra d5, gr3sbb
gr3sbx:
 movem.l (a7)+, d0-d6/a0/a3
 rts


gr3p27:                         * Sprite lschen GDP-COL
 movem.l d0-d6/a0-a4, -(a7)     * a0 zeigt auf Speicher
 move.b (a0)+, d0               * Spriteart
 cmp.b #2, d0                   * GDP-COL-Sprite 88 bis 5128 Byte gro
 bne gr3p27f                    * sonst Fehler
 move.b gdpwpage(a5), d0        * Schreibseite
 lsl #8, d0
 move.b gdpxor(a5), d0          * XOR-Mode
 move d0, -(a7)                 * auf Stack retten
 move.b (a0)+, gdpwpage(a5)     * alte Schreibseite
 clr.b gdpxor(a5)               * kein XOR
 bsr gr1page                    * Seite und XOR-Modus setzen
 moveq #2, d6                   * WAIT-Bit der GDP-Karte
 moveq #$80, d7                 * Befehl fr Punkt setzen
 lea gdp.w, a6                  * GDP-Basis fr WAIT
 lea gdp+1*cpu.w, a3            * GDP-CTRL1
 lea gdp+8*cpu.w, a1            * X-Register GDP
 lea gdp+$b*cpu.w, a4           * Y-Register LSB
 lea colport.w, a2              * Vordergrundfarbe
 clr.b colport1.w               * Hintergrundfarbe auf 0
 move (a0)+, d1                 * X-Koordinate
 move (a0)+, d2                 * Y-Koordinate
 move.b (a0)+, d3               * X-Scalierung
 move.b (a0)+, d4               * Y-Scalierung
 addq #8, a0                    * +8 um auf Bilddaten zu kommen
 moveq #8, d5                   * 8 Zeilen
 lsl d4, d5                     * Zeilen*Y-Scalierung
 subq #1, d5                    * -1 als Zhler
 btst #0, d1                    * X gerade oder ungerade
 bne.s gr3p27c                  * ungerade
gr3p27a:                        * Gerade Adresse
 moveq #1, d4                   * Zhler fr X-Scalierung
 lsl d3, d4                     * *X-Scalierung
 subq #1 ,d4                    * -1 als Zhler
gr3p27a1:
 tst d2                         * Y >=0 ?
 bpl.s gr3p27b                  * ja, dann Ausgabe
 moveq #10, d0                  * 10 Byte/Zeile
 lsl d3, d0                     * *X-Scalierung
 adda.l d0, a0
 addq #1, d2                    * nchste Zeile
 dbra d5, gr3p27a1
 bra gr3p27e                    * hier Ende
gr3p27b:
 cmp #256, d2                   * oberer Rand berschritten?
 bge gr3p27e                    * dann Ende
 move.b d2, (a4)                * Y-Koordinaten setzen
 move d4, -(a7)                 * X-Scale-Zhler retten
 move d1, -(a7)                 * X-Koordinate retten
gr3p27b1:
 move d4, -(a7)                 * X-Scal-Zhler retten
 move.l (a0)+, d0
 bsr gr3ap8                     * 8 Pixel schreiben
 move.l (a0)+, d0
 bsr gr3ap8                     * 8 Pixel schreiben
 move (a7)+, d4                 * X-Scale-Zhler zurck
 addq #2, a0                    * auf 10 Byte bringen
 dbra d4, gr3p27b1              * X-Scale-Loop
 move (a7)+, d1                 * X-Koordinate zurck
 move (a7)+, d4                 * X-Scale-Zhler zurck
 addq #1, d2                    * Y-Koordinate erhhen
 dbra d5, gr3p27b
 bra.s gr3p27e
gr3p27c:                        * Ungerade Adresse
 moveq #1, d4                   * Zhler fr X-Scalierung
 lsl d3, d4                     * *X-Scalierung
 subq #1 ,d4                    * -1 als Zhler
gr3p27c1:
 tst d2                         * Y >=0 ?
 bpl.s gr3p27d                  * ja, dann Ausgabe
 moveq #10, d0                  * 10 Byte/Zeile
 lsl d3, d0                     * *X-Scalierung
 adda.l d0, a0
 addq #1, d2                    * nchste Zeile
 dbra d5, gr3p27c1
 bra.s gr3p27e                  * hier Ende
gr3p27d:
 cmp #256, d2                   * oberer Rand berschritten?
 bge.s gr3p27e                  * dann Ende
 move.b d2, (a4)                * Y-Koordinaten setzen
 move d4, -(a7)                 * X-Scal-Zhler retten
 move d1, -(a7)                 * X-Koordinate retten
gr3p27d1:
 move d4, -(a7)                 * X-Scal-Zhler retten
 move.l (a0)+, d0               * 8 Pixel holen
 lsl.l #4, d0                   * ein Pixel raus
 move.b (a0), d4                * noch 2 Pixel
 lsr.b #4, d4                   * nur das Oberste
 and.b #$0f, d4
 or.b d4, d0                    * dazu
 bsr gr3ap8                     * 8 Pixel schreiben
 move.l (a0)+, d0               * 8 Pixel holen
 lsl.l #4, d0                   * ein Pixel raus
 move.b (a0), d4                * noch 2 Pixel
 lsr.b #4, d4                   * nur das Oberste
 and.b #$0f, d4
 or.b d4, d0                    * dazu
 bsr gr3ap8                     * 8 Pixel schreiben
 move (a7)+, d4                 * X-Scal-Zhler zurck
 addq #2, a0                    * auf 10 Byte bringen
 dbra d4, gr3p27d1              * X-Scal-Loop
 move (a7)+, d1                 * X-Koordinate zurck
 move (a7)+, d4                 * X-Scal-Zhler zurck
 addq #1, d2                    * Y-Koordinate erhhen
 dbra d5, gr3p27d
gr3p27e:
 move (a7)+, d0
 move.b d0, gdpxor(a5)
 lsr #8, d0
 move.b d0, gdpwpage(a5)
 bsr gr1page                    * Seite und XOR-Modus setzen
 bset.b #1, (a3)                * Schreibstift muss gesetzt werden!
 movem.l (a7)+, d0-d6/a0-a4
 bra carres
gr3p27f:
 movem.l (a7)+, d0-d6/a0-a4
 bra carset

gr3ap8:
 moveq #8-1, d3                 * 8 Pixel
gr3ap8a:
 move d1, d4                    * X-Koordinate
 bpl.s gr3ap8b                  *
 rol.l #4, d0
 addq #1, d1
 dbra d3, gr3ap8a               * bis X-Koordinate >=0
 bra.s gr3ap8f                  * sonst Ende
gr3ap8b:
 cmp #512, d1                   * ber rechten Rand?
 bge.s gr3ap8f                  * ja, dann Ende
 movep.w d1, 0(a1)              * Neue X-Koordinate -- Nur fr 68000
 rol.l #4, d0                   * ein Pixel in Bit #3-0
 move.b d0, d4
 and.b #$0f, d4                 * Pixel in Bit #3-0
 beq.s gr3ap8d                  * Schwarz
gr3ap8c:
 btst.b d6, (a6)                * Warten
 beq.s gr3ap8c
 bset.b #1, (a3)                * Schreibstift
 move.b d4, (a2)                * Farbe setzen
 bra.s gr3ap8e
gr3ap8d:
 btst.b d6, (a6)                * Warten
 beq.s gr3ap8d
 bclr.b #1, (a3)                * Lschstift
gr3ap8e:
 move.b d7, (a6)                * Punkt setzen
 addq #1, d1
 dbra d3, gr3ap8b               * nchster Punkt
gr3ap8f:
 rts

gr3p32:                         * Bereich speichern
 movem.l d0-d6/a0/a2-a4/a6, -(a7)
 lea page.w, a3                 * Seiten Register
 lea gdp.w, a6                  * GDP-Basis fr WAIT
 lea gdp+8*cpu.w, a2            * X-Register GDP
 lea gdp+$b*cpu.w, a4           * Y-Register LSB
 move.l #$1FF, d0               * max. 511
 and.l d0, d1                   * X=0..511
 and.l d0, d2                   * Y=0..511
 subq #1, d3                    * auf 1..511 als Breitenzhler
 and.l d0, d3
 subq.l #1, d4                  * auf 1..511
 and.l d0, d4
 asr #1, d2                     * Y auf 0..255
 asr #1, d4                     * Hhe auf 0..255
 btst #0, d1                    * gerade Adresse?
 bne.s gr3p32d                  * nein!
gr3p32a:                        * gerade Adresse
 move.b d2, (a4)                * Y-Koordinate setzen
 movem d1/d3, -(a7)             * X-Koordinate u. Breitenzhler sichern
gr3p32b:
 movep.w d1, 0(a2)              * X-Koordinate setzen --- Nur fr 68000
 move.b #$f, (a6)               * Befehl fr Speicher auslesen
gr3p32c:
 btst.b #2, (a6)                * WAIT
 beq.s gr3p32c
 move.b (a3), d0                * 2 Pixel holen
 not.b d0                       * invertieren
 move.b d0, (a0)+               * speichern
 addq #2, d1                    * nchsten Pixel
 subq #2, d3
 bpl.s gr3p32b
 movem (a7)+, d1/d3             * X-Koordinate u.Breitenzhler zurck
 addq #1, d2                    * nchste Zeile
 dbra d4, gr3p32a
 bra.b gr3p32x
gr3p32d:                        * ungerade Adresse
 and #$fffe, d1                 * auf gerade Adresse
gr3p32e:
 move.b d2, (a4)                * Y-Koordinate setzen
 movem d1/d3, -(a7)             * X-Koordinate u. Breitenzhler sichern
 movep.w d1, 0(a2)              * X-Koordinate setzen --- Nur fr 68000
 move.b #$f, (a6)               * Befehl fr Speicher auslesen
gr3p32f:
 btst.b #2, (a6)                * WAIT
 beq.s gr3p32f
 move.b (a3), d0                * 1. Pixel holen
 not.b d0                       * invertieren
 rol.b #4, d0                   * Reihenfolge vertauschen
 move.b d0, d6
 and.b #$f0, d6                 * nur oberes Nibble lassen
 addq #2, d1
gr3p32g:
 movep.w d1, 0(a2)              * X-Koordinate setzen --- Nur fr 68000
 move.b #$f, (a6)               * Befehl fr Speicher auslesen
gr3p32h:
 btst.b #2, (a6)                * WAIT
 beq.s gr3p32h
 move.b (a3), d0                * Pixel holen
 not.b d0                       * invertieren
 rol.b #4, d0                   * Reihenfolge vertauschen
 move.b d0, d5
 and.b #$f, d5                  * nur unteres Nibble lassen
 or.b d5, d6                    * Pixel vereinigt ;-)
 move.b d6, (a0)+               * speichern
 and.b #$f0, d0                 * oberes Nibble behalten
 move.b d0, d6
 addq #2, d1                    * nchsten Pixel
 subq #2, d3
 bpl.s gr3p32g
 movem (a7)+, d1/d3             * X-Koordinate u.Breitenzhler zurck
 addq #1, d2                    * nchste Zeile
 dbra d4, gr3p32e
gr3p32x:
 movem.l (a7)+, d0-d6/a0/a2-a4/a6
 rts

gr3p33:                         * Bereich schreiben
 movem.l d0-d7/a0/a2-a4/a6, -(a7)
 lea gdp.w, a6                  * GDP-Basis fr WAIT
 lea colport.w, a1              * Vordergrund-Farbe
 lea gdp+8*cpu.w, a2            * X-Register GDP
 lea gdp+1*cpu.w, a3            * GDP-CTRL1
 lea gdp+$b*cpu.w, a4           * Y-Register LSB
 clr.b colport1.w               * Hintergrund-Farbe auf 0
 move.l #$1FF, d0               * max. 511
 and.l d0, d1
 and.l d0, d2
 subq.l #1, d3                  * auf 1..511
 and.l d0, d3
 subq.l #1, d4                  * auf 1..511
 and.l d0, d4
 asr #1, d2                     * Y auf 0..255
 asr #1, d4                     * Hhe auf 0..255
 moveq #2, d6                   * Bit frs Warten
gr3p33a:
 move.b d2, (a4)                * Y-Koordinate ausgeben
 movem d1/d3, -(a7)             * X-Koordinate u. Breitenzhler retten
gr3p33b:
 moveq #2-1, d5                 * Pixel in Byte
 move.b (a0)+, d0               * 2 Pixel
gr3p33c:
 movep.w d1, 0(a2)              * Neue X-Koordinate -- Nur fr 68000
 rol.b #4, d0                   * Pixel in Bit #0-3
 move.b d0, d7
 and.b #$f, d7                  * nur ein Pixel lassen
 beq.s gr3p33e                  * Schwarz
gr3p33d:
 btst.b d6, (a6)                * Warten
 beq.s gr3p33d
 move.b d7, (a1)                * Pixel an Colport
 bset.b #1, (a3)                * Schreibstift
 bra.s gr3p33f
gr3p33e:
 btst.b d6, (a6)                * Warten
 beq.s gr3p33e
 bclr.b #1, (a3)                * Lschstift
gr3p33f:
 move.b #$80, (a6)              * Punkt setzen
 addq #1, d1
 subq #1, d3
 bmi.s gr3p33g                  * Zeile fertig
 dbra d5, gr3p33c               * nchster Punkt
 bra.s gr3p33b
gr3p33g:
 movem (a7)+, d1/d3             * X-Koordinate u. Breitenzhler zurck
 addq #1, d2                    * nchstes Y
 dbra d4, gr3p33a
 bset.b #1, (a3)                * wieder auf Schreibstift!!!
 movem.l (a7)+, d0-d7/a0/a2-a4/a6
 rts

g3moveto:                       * MOVETO fr GDP-COL-Paket
 asr #1,d2
move3to:                        * Schreibstift der GDP positionieren
 btst.b #2,gdp.w                * d1 = X  d2 = Y
 beq.s move3to                  * Ohne Sprung zu wait schneller
 move.l a0,-(a7)                * ==> Nur fr 68000/68010
 lea gdp.w,a0
 movep.w d1,8*cpu(a0)           * X Register gesetzt
 movep.w d2,$a*cpu(a0)          * Y Register gesetzt
 movea.l (a7)+,a0
 rts

wait3:                          * Warten bis GDP fertig
 btst.b #2,gdp.w                * Bit 2 prfen
 beq.s wait3                    * Warten bis auf 1
 rts

ende:                           * Endemarkierung fr Lngenberechnung

df.b 1024*64-*,$ff              * Rest der 64 Kbyte mit $FF fllen

end                                                                               